import 'package:get_it/get_it.dart';
import 'package:google_place/google_place.dart';
import 'package:gshop/app_constants.dart';

// import 'package:google_place/google_place.dart';
import 'package:gshop/domain/interface/address.dart';
import 'package:gshop/domain/interface/auth.dart';
import 'package:gshop/domain/interface/banner.dart';
import 'package:gshop/domain/interface/blog.dart';
import 'package:gshop/domain/interface/brands.dart';
import 'package:gshop/domain/interface/cart.dart';
import 'package:gshop/domain/interface/category.dart';
import 'package:gshop/domain/interface/chat.dart';
import 'package:gshop/domain/interface/gallery.dart';
import 'package:gshop/domain/interface/order.dart';
import 'package:gshop/domain/interface/parcel.dart';
import 'package:gshop/domain/interface/payments.dart';
import 'package:gshop/domain/interface/products.dart';
import 'package:gshop/domain/interface/review.dart';
import 'package:gshop/domain/interface/settings.dart';
import 'package:gshop/domain/interface/shop.dart';
import 'package:gshop/domain/interface/user.dart';
import 'package:gshop/infrastructure/service//http_service.dart';
import 'package:gshop/infrastructure/repository/address_repository.dart';
import 'package:gshop/infrastructure/repository/auth_repository.dart';
import 'package:gshop/infrastructure/repository/banners_repository.dart';
import 'package:gshop/infrastructure/repository/blogs_repository.dart';
import 'package:gshop/infrastructure/repository/brands_repository.dart';
import 'package:gshop/infrastructure/repository/cart_repository.dart';
import 'package:gshop/infrastructure/repository/categories_repository.dart';
import 'package:gshop/infrastructure/repository/chat_repository.dart';
import 'package:gshop/infrastructure/repository/gallery_repository.dart';
import 'package:gshop/infrastructure/repository/order_repository.dart';
import 'package:gshop/infrastructure/repository/parcel_repository.dart';
import 'package:gshop/infrastructure/repository/payments_repository.dart';
import 'package:gshop/infrastructure/repository/products_repository.dart';
import 'package:gshop/infrastructure/repository/review_repository.dart';
import 'package:gshop/infrastructure/repository/settings_repository.dart';
import 'package:gshop/infrastructure/repository/shops_repository.dart';
import 'package:gshop/infrastructure/repository/user_repository.dart';

final GetIt getIt = GetIt.instance;

Future<void> setUpDependencies() async {
  getIt.registerSingleton<HttpService>(HttpService());
  getIt.registerLazySingleton<SettingsInterface>(() => SettingsRepository());
  getIt.registerLazySingleton<AuthInterface>(() => AuthRepository());
  getIt.registerLazySingleton<CategoryInterface>(() => CategoryRepository());
  getIt.registerLazySingleton<BannersInterface>(() => BannersRepository());
  getIt.registerLazySingleton<ProductsInterface>(() => ProductsRepository());
  getIt.registerLazySingleton<BlogInterface>(() => BlogsRepository());
  getIt.registerLazySingleton<ShopsInterface>(() => ShopsRepository());
  getIt.registerLazySingleton<BrandsInterface>(() => BrandsRepository());
  getIt.registerLazySingleton<GalleryInterface>(() => GalleryRepository());
  getIt.registerLazySingleton<UserInterface>(() => UserRepository());
  getIt.registerLazySingleton<ChatInterface>(() => ChatRepository());
  getIt.registerLazySingleton<AddressInterface>(() => AddressRepository());
  getIt.registerLazySingleton<CartInterface>(() => CartRepository());
  getIt.registerLazySingleton<ParcelInterface>(() => ParcelRepository());

  getIt.registerLazySingleton<GooglePlace>(
      () => GooglePlace(AppConstants.googleApiKey));
  getIt.registerLazySingleton<PaymentsInterface>(() => PaymentsRepository());
  getIt.registerLazySingleton<OrderInterface>(() => OrderRepository());
  getIt.registerLazySingleton<ReviewInterface>(() => ReviewRepository());
}

final settingsRepository = getIt.get<SettingsInterface>();
final dioHttp = getIt.get<HttpService>();
final authRepository = getIt.get<AuthInterface>();
final categoriesRepository = getIt.get<CategoryInterface>();
final bannersRepository = getIt.get<BannersInterface>();
final productsRepository = getIt.get<ProductsInterface>();
final blogsRepository = getIt.get<BlogInterface>();
final shopsRepository = getIt.get<ShopsInterface>();
final brandsRepository = getIt.get<BrandsInterface>();
final galleryRepository = getIt.get<GalleryInterface>();
final userRepository = getIt.get<UserInterface>();
final chatRepository = getIt.get<ChatInterface>();
final addressRepository = getIt.get<AddressInterface>();
final cartRepository = getIt.get<CartInterface>();
final googlePlace = getIt.get<GooglePlace>();
final paymentsRepository = getIt.get<PaymentsInterface>();
final ordersRepository = getIt.get<OrderInterface>();
final reviewRepository = getIt.get<ReviewInterface>();
final parcelRepository = getIt.get<ParcelInterface>();
