import { IconType } from "@/types/utils";
import React from "react";

export const NavigatorIcon: IconType = ({ size, ...otherProps }) => (
  <svg
    width={size || "20"}
    height={size || "20"}
    {...otherProps}
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <g clipPath="url(#clip0_1_7369)">
      <path
        d="M4.1373 4.2462L7.0923 14.5879L9.62563 9.5212L14.3231 7.64203L4.1373 4.2462ZM2.41563 1.9162L18.0873 7.13953C18.1684 7.16642 18.2393 7.21759 18.2903 7.28612C18.3414 7.35464 18.3701 7.43721 18.3727 7.52262C18.3752 7.60803 18.3515 7.69216 18.3046 7.76361C18.2577 7.83506 18.19 7.89036 18.1106 7.92203L10.8331 10.8329L7.14563 18.2079C7.10811 18.283 7.04878 18.345 6.9754 18.3858C6.90203 18.4266 6.81805 18.4443 6.73446 18.4365C6.65086 18.4288 6.57156 18.396 6.50694 18.3424C6.44231 18.2888 6.39538 18.2169 6.3723 18.1362L1.88313 2.42536C1.86234 2.35238 1.86187 2.2751 1.88179 2.20186C1.9017 2.12863 1.94124 2.06223 1.99613 2.00982C2.05103 1.95742 2.11919 1.921 2.19327 1.9045C2.26734 1.888 2.34452 1.89204 2.41647 1.9162H2.41563Z"
        fill="currentColor"
      />
    </g>
    <defs>
      <clipPath id="clip0_1_7369">
        <rect width="20" height="20" fill="white" />
      </clipPath>
    </defs>
  </svg>
);
